(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     36894,        961]*)
(*NotebookOutlinePosition[     38620,       1011]*)
(*  CellTagsIndexPosition[     38576,       1007]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Integrales de superficie. Teoremas de la divergencia y de Stokes\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada
\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializacion", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[ParametricPlot::ppcom]\), "\n", 
    \(Off[General::spell1]\)}], "Input"],

Cell[BoxData[
    \(<< Graphics`Arrow`\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Colors`\)], "Input"],

Cell[BoxData[{
    \(\(\(norma[x_] := N[\@\(x . x\)]\)\(\ \)\);  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]];\), "\n", 
    \( (*\ un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)}], "Input"],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := \(\(arrow3D[x, x + y, color, 
        grosor]\)\(\ \)\)\)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrales de superficie", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Para cada una de las siguientes superficies calcula un vector normal \
unitario en un punto gen\[EAcute]rico de la superficie, el plano tangente en \
el punto que se indica en cada caso y representa gr\[AAcute]ficamente (una \
parte de) la superficie junto con la recta normal y el plano tangente en el \
punto indicado. \na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{"u", " ", "cos", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"u", " ", "sen", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((1 - u\^2)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] u \[LessEqual] 1, \ 
      0 \[LessEqual] v \[LessEqual] 2  \[Pi]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \[Gamma](1/\@2, \[Pi]/2)\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{\(\@2\), "sen", " ", "u", " ", "cos", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
            "2", \(\@2\), "sen", " ", "u", " ", "sen", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{\(\@3\), "cos", " ", "u", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] u \[LessEqual] \[Pi], \ 
      0 \[LessEqual] v \[LessEqual] 2  \[Pi]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((1/2, 1, 3/2)\)\)]],
  ".\nc) ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](u, v) = \((2  u + 2  v, u - v, u\ v)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] u \[LessEqual] 
        1, \ \(-1\) \[LessEqual] v \[LessEqual] 1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((2, 0, 1/4)\)\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(\(\[Gamma][u_, v_] = {u\ Cos[v], \ u\ Sin[v], \ 
          1 - u^2};\)\), "\[IndentingNewLine]", 
    \(\({a, b} = {N[1/\@2], N[\(-Pi\)/2]};\)\), "\[IndentingNewLine]", 
    \(\(v1 = 
        D[\[Gamma][u, v], u] /. {u \[Rule] a, 
            v \[Rule] b};\)\), "\[IndentingNewLine]", 
    \(\(v2 = 
        D[\[Gamma][u, v], v] /. {u \[Rule] a, 
            v \[Rule] b};\)\), "\[IndentingNewLine]", 
    \(\(vectnormal = 
        vector3D[\[Gamma][a, b], Cross[v1, v2], 
          Red,  .008];\)\), "\[IndentingNewLine]", 
    \(\(graf1 = 
        ParametricPlot3D[\[Gamma][u, v], {u, 0, 1}, {v, 0, 2  Pi}, 
          Boxed \[Rule] False, \ Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(graf2 = 
        ParametricPlot3D[\[Gamma][a, b] + s*v1 + 
            t*v2, {s, \(- .5\),  .5}, {t, \(- .5\),  .5}, 
          Boxed \[Rule] False, \ Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[graf1, graf2, Graphics3D[vectnormal], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell[BoxData[{
    \(\(\[Gamma][u_, v_] = {\(\@2\) Sin[u]\ Cos[v], 
          2 \(\@ 2\) Sin[u]\ Sin[v], \ \(\@3\) 
            Cos[u]};\)\), "\[IndentingNewLine]", 
    \(\({a, b} = { .5,  .5};\)\), "\[IndentingNewLine]", 
    \(\(v1 = 
        D[\[Gamma][u, v], u] /. {u \[Rule] a, 
            v \[Rule] b};\)\), "\[IndentingNewLine]", 
    \(\(v2 = 
        D[\[Gamma][u, v], v] /. {u \[Rule] a, 
            v \[Rule] b};\)\), "\[IndentingNewLine]", 
    \(\(vectnormal = 
        vector3D[\[Gamma][a, b], Cross[v1, v2], 
          Red,  .008];\)\), "\[IndentingNewLine]", 
    \(\(graf1 = 
        ParametricPlot3D[\[Gamma][u, v], {u, 0, Pi}, {v, 0, 2  Pi}, 
          Boxed \[Rule] False, \ Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(graf2 = 
        ParametricPlot3D[\[Gamma][a, b] + s*v1 + 
            t*v2, {s, \(- .5\),  .5}, {t, \(- .5\),  .5}, 
          Boxed \[Rule] False, \ Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[graf1, graf2, Graphics3D[vectnormal], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell[BoxData[{
    \(\(\[Gamma][u_, v_] = {2  u + 2  v, u - v, 
          u\ v};\)\), "\[IndentingNewLine]", 
    \(\({a, b} = {N[Pi/4], N[Pi/3]};\)\), "\[IndentingNewLine]", 
    \(\(v1 = 
        D[\[Gamma][u, v], u] /. {u \[Rule] a, 
            v \[Rule] b};\)\), "\[IndentingNewLine]", 
    \(\(v2 = 
        D[\[Gamma][u, v], v] /. {u \[Rule] a, 
            v \[Rule] b};\)\), "\[IndentingNewLine]", 
    \(\(vectnormal = 
        vector3D[\[Gamma][a, b], Cross[v1, v2], 
          Red,  .008];\)\), "\[IndentingNewLine]", 
    \(\(graf1 = 
        ParametricPlot3D[\[Gamma][u, v], {u, \(-1\), 1}, {v, \(-1\), 1}, 
          Boxed \[Rule] False, \ Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(graf2 = 
        ParametricPlot3D[\[Gamma][a, b] + s*v1 + 
            t*v2, {s, \(- .5\),  .5}, {t, \(- .5\),  .5}, 
          Boxed \[Rule] False, \ Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[graf1, graf2, Graphics3D[vectnormal], 
        DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell["\<\
a) Define un comando que calcule simb\[OAcute]licamente integrales de \
superficie de campos escalares. La sintaxis de este comando debe ser de la \
forma \"integsuperficie[func][super,{s,smin,smax},{t,tmin,tmax}]\", donde \
debes suponer que \"func\" es el nombre de una funci\[OAcute]n conocida de \
tres variables y \"super\" es el nombre de la funci\[OAcute]n que nos da la \
superficie en forma param\[EAcute]trica para valores de los \
par\[AAcute]metros en el rect\[AAcute]ngulo [smin,smax]\[Times][tmin,tmax].
Aqu\[IAcute] tienes un ejemplo de lo que debe ser capaz de hacer tu comando (\
\[DownExclamation]no ejecutes la celda!).\
\>", "ExerciseText"],

Cell[BoxData[
    \(\(\(f[x_, y_, z_] = x + y + z\)\(;\)\(\ \)\( (*\ 
      el\ campo\ escalar\ *) \)\(\n\)\(\[Gamma][s_, t_] = {t, s, 
        t + s}\)\(;\)\(\ \)\( (*\ 0 \[LessEqual] s, 
      t \[LessEqual] 
        1\ la\ superficie\ de\ integraci\[OAcute]n\ *) \)\(\n\
\)\(\(integsuperficie[f]\)[\[Gamma], {s, 0, 1}, {t, 0, 1}]\)\( (*\ 
      este\ es\ el\ comando\ que\ t\[UAcute]\ debes\ definir\ y\ tiene\ que\ \
calcular\ simb\[OAcute]licamente\ la\ integral\ de\ superficie\ del\ campo\ \
escalar\ f\ *) \)\)\)], "Input"],

Cell["\<\
a2) Para el caso en que la funci\[OAcute]n \"super\" est\[EAcute] definida en \
un sector de una corona circular, modifica el comando definido en el apartado \
anterior para que calcule la integral en coordenadas polares.\
\>", "ExerciseText"],

Cell[TextData[{
  "b) Usa el comando que has definido para calcular las integrales de los \
campos escalares ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en las superficies dadas:\nb1) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x + y + z, \ \[Gamma](s, t) = \((s, t, s + t)\), \ 0 \[LessEqual] s, 
      t \[LessEqual] 1\)]],
  ".\nb2) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x\^2 + y\^2 + z, \ \[Gamma](s, t) = \((sen\ t\ cos\ s, 
          sen\ t\ sen\ s, cos\ t)\), \ \ 0 \[LessEqual] 
        s, \(\(t\)\(\[LessEqual]\)\(\[Pi]\)\(\ \)\)\)]],
  ".\nb3) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x\ z, \[Gamma](s, t) = \((s, t, 
          1 - s\^2 - t\^2)\), \ \ 0 \[LessEqual] s, t \[LessEqual] 1\)]],
  ".\nb4) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = \(x\^2\) y + z\^2\)]],
  " en la superficie formada por la parte del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 9\)]],
  " comprendida entre los planos ",
  Cell[BoxData[
      \(TraditionalForm\`z = 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`z = 2\)]],
  ".\nb5) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = y\ z\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{"u", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((u + v)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((u - v)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`u\^2 + v\^2 \[LessEqual] 1\)]],
  "."
}], "ExerciseText"],

Cell[TextData[{
  "c) Repite lo hecho en el apartado a) para el caso en que la superficie \
venga dada como la gr\[AAcute]fica de una funci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`z = h(x, y)\)]],
  ". Considera dos posibilidades: que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " est\[EAcute] definida en un rect\[AAcute]ngulo del plano o que est\
\[EAcute] definida en un sector de una corona circular. En este \
\[UAcute]ltimo caso debes definir el comando para que calcule la integral en \
coordenadas polares. "
}], "ExerciseText"],

Cell[BoxData[
    \(\(integsuperficie[f_]\)[\[Gamma]_, {s_, smin_, smax_}, {t_, tmin_, 
          tmax_}] := 
      Integrate[
        Simplify[Apply[f, \[Gamma][s, t]]]*
          Norm[Simplify[
              Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]]]], {s, smin, 
          smax}, {t, tmin, tmax}]\)], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_, z_] = x + y + z;\)\), "\n", 
    \(\(\[Gamma][s_, t_] = {t, s, t + s};\)\), "\n", 
    \(\(integsuperficie[f]\)[\[Gamma], {s, 0, 1}, {t, 0, 1}]\)}], "Input"],

Cell[BoxData[{
    \(Clear[f, \[Gamma]]\), "\n", 
    \(\(f[x_, y_, z_] = x\^2 + y\^2 + z;\)\), "\n", 
    \(\(\[Gamma][s_, t_] = {Sin[t] Cos[s], Sin[t] Sin[s], 
          Cos[t]};\)\), "\n", 
    \(\(integsuperficie[f]\)[\[Gamma], {s, 0, \[Pi]}, {t, 
        0, \[Pi]}]\)}], "Input"],

Cell[BoxData[{
    \(Clear[f, \[Gamma]]\), "\n", 
    \(\(f[x_, y_, z_] = x*z;\)\), "\n", 
    \(\(\[Gamma][s_, t_] = {s, t, 1 - s\^2 - t\^2};\)\), "\n", 
    \(\(integsuperficie[f]\)[\[Gamma], {s, 0, 1}, {t, 0, 1}]\)}], "Input"],

Cell[BoxData[{
    \(Clear[f, \[Gamma]]\), "\n", 
    \(\(f[x_, y_, z_] = \(x\^2\) y + z\^2;\)\), "\n", 
    \(\(\[Gamma][\[Theta]_, z_] := {3\ Cos[\[Theta]], 3\ Sin[\[Theta]], 
          z};\)\), "\n", 
    \(\(integsuperficie[f]\)[\[Gamma], {\[Theta], 0, 2  \[Pi]}, {z, 0, 
        2}]\)}], "Input"],

Cell[BoxData[
    \(\(integsuperficiepolares[
          f_]\)[\[Gamma]_, {\[Theta]_, \[Theta]min_, \[Theta]max_}, {\[Rho]_, \
\[Rho]min_, \[Rho]max_}] := 
      Integrate[
        Simplify[\[Rho]*\((Apply[f, \[Gamma][s, t]]*
                  Norm[Cross[D[\[Gamma][s, t], s], 
                      D[\[Gamma][s, t], 
                        t]]])\) /. {s \[Rule] \[Rho]\ Cos[\[Theta]], 
              t \[Rule] \[Rho]\ Sin[\[Theta]]}], {\[Theta], \[Theta]min, \
\[Theta]max}, {\[Rho], \[Rho]min, \[Rho]max}]\)], "Input"],

Cell[BoxData[{
    \(Clear[f, \[Gamma]]\), "\n", 
    \(\(f[x_, y_, z_] = y\ z;\)\), "\n", 
    \(\(\[Gamma][u_, v_] := {u\ v, u + v, u - v};\)\), "\n", 
    \(\(integsuperficiepolares[f]\)[\[Gamma], {\[Theta], 0, 
        2  \[Pi]}, {\[Rho], 0, 1}]\)}], "Input"],

Cell[BoxData[
    \(\(integsuperficie[f]\)[\[Gamma], {u, \(-1\), 
        1}, {v, \(-\@\(1 - u\^2\)\), \@\(1 - u\^2\)}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Consideremos la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " cuya ecuaci\[OAcute]n en coordenadas esf\[EAcute]ricas es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = \[Theta], \ 
      0 \[LessEqual] \[Theta] \[LessEqual] \[Pi]/2, \ 
      0 \[LessEqual] \[Phi] \[LessEqual] \(\(\[Pi]\)\(.\)\)\)]],
  " Para pon\[EAcute]rtelo m\[AAcute]s f\[AAcute]cil, se trata de la \
superficie cuyas ecuaciones param\[EAcute]tricas en coordenadas cartesianas \
son"
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`\[Gamma](\[Theta], \[Phi]) = \(G(\[Theta], \[Theta], \
\[Phi])\)\ \ con\ \ 0 \[LessEqual] \[Theta] \[LessEqual] \[Pi]/2, \ 
    0 \[LessEqual] \[Phi] \[LessEqual] \[Pi], \)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`G(\[Rho], \[Theta], \[Phi]) = \((\[Rho]\ cos\ \[Phi]\
\ sen\ \[Theta], \ \[Rho]\ sen\ \[Phi]\ sen\ \[Theta], \ \[Rho]\ cos\ \
\[Theta])\)\)]],
  " es la conocida funci\[OAcute]n que introduce las cordenadas \
esf\[EAcute]ricas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ".\na) Representa la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " junto con las rectas que pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](\[Pi]/6, \[Pi]/2)\)]],
  " con vectores de direcci\[OAcute]n dados por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]\[Gamma]\/\[PartialD]\[Theta]\) \
\((\[Pi]/6, \[Pi]/2)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]\[Gamma]\/\[PartialD]\[Phi]\) \((\[Pi]/
            6, \[Pi]/2)\)\)]],
  ". Representa tambi\[EAcute]n gr\[AAcute]ficamente la recta normal a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en dicho punto.\nb) Calcula el centroide de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " y representa el centroide en la gr\[AAcute]fica anterior en \
tama\[NTilde]o y color apropiados para que se vea bien. "
}], "ExerciseText"],

Cell[BoxData[{
    \(\(G[\[Theta]_, \[Phi]_] = {\[Theta]\ Cos[\[Phi]]\ Sin[\[Theta]], \
\[Theta]\ Sin[\[Phi]]\ Sin[\[Theta]], \[Theta]\ Cos[\[Theta]]};\)\), "\
\[IndentingNewLine]", 
    \(\(Transpose[{D[G[\[Theta], \[Phi]], \[Theta]], 
            D[G[\[Theta], \[Phi]], \[Phi]]}] // MatrixForm\) // 
      Simplify\)}], "Input"],

Cell[BoxData[
    \(\(superficie = 
        ParametricPlot3D[{\[Theta]\ Cos[\[Phi]]\ Sin[\[Theta]], \[Theta]\ \
Sin[\[Phi]]\ Sin[\[Theta]], \[Theta]\ Cos[\[Theta]]}, {\[Theta], 
            0, \[Pi]/2}, {\[Phi], 0, \[Pi]}, AspectRatio \[Rule] Automatic, 
          Boxed \[Rule] False, Axes \[Rule] False, 
          ViewPoint -> {\(-0.121\), \ 2.851, \ \(-1.819\)}];\)\)], "Input"],

Cell[BoxData[{
    \(\(f1[x_, y_, z_] = x;\)\), "\[IndentingNewLine]", 
    \(\(f2[x_, y_, z_] = y;\)\), "\[IndentingNewLine]", 
    \(\(f3[x_, y_, z_] = z;\)\), "\[IndentingNewLine]", 
    \(\(\(fc[x_, y_, z_] = 1;\)\(\[IndentingNewLine]\)
    \) (*\ \(\[Gamma][\[Phi]_, \[Theta]_] = {Cos[\[Phi]]\ Sin[\[Theta]], 
            Sin[\[Phi]]\ Sin[\[Theta]], \ 
            Cos[\[Theta]]};\)*) \), "\[IndentingNewLine]", 
    \(\(N[\(integsuperficie[f1]\)[
          G, {\[Theta], 0, \[Pi]/2}, {\[Phi], 
            0, \[Pi]}]];\)\), "\[IndentingNewLine]", 
    \(\(N[\(integsuperficie[f2]\)[
          G, {\[Theta], 0, \[Pi]/2}, {\[Phi], 
            0, \[Pi]}]];\)\), "\[IndentingNewLine]", 
    \(\(N[\(integsuperficie[f3]\)[
          G, {\[Theta], 0, \[Pi]/2}, {\[Phi], 
            0, \[Pi]}]];\)\), "\[IndentingNewLine]", 
    \(\(N[\(integsuperficie[fc]\)[
          G, {\[Theta], 0, \[Pi]/2}, {\[Phi], 
            0, \[Pi]}]];\)\), "\[IndentingNewLine]", 
    \(centroide = {%%%%/%, %%%/%, %%/%}\)}], "Input"],

Cell[BoxData[
    \(\(Show[{superficie, 
          Graphics3D[{Hue[0.12], PointSize[ .03], 
              Point[centroide]}]}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a1) Define un comando que calcule simb\[OAcute]licamente integrales de \
superficie de campos vectoriales. La sintaxis de este comando debe ser de la \
forma \"vectorintegsuperficie[func][super,{s,smin,smax},{t,tmin,tmax}]\", \
donde debes suponer que \"func\" es el nombre del campo vectorial que se \
integra y \"super\" es el nombre de la funci\[OAcute]n que nos da la \
superficie en forma param\[EAcute]trica para valores de los \
par\[AAcute]metros en el rect\[AAcute]ngulo [smin,smax]\[Times][tmin,tmax]. \
Tambi\[EAcute]n debes suponer que la orientaci\[OAcute]n de la superficie es \
la inducida por la parametrizaci\[OAcute]n dada. \na2) Para el caso en que la \
funci\[OAcute]n \"super\" est\[EAcute] definida en un sector de una corona \
circular, modifica el comando definido en el apartado anterior para que \
calcule la integral en coordenadas polares.\nb) Calcula el flujo del campo \
vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"x", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Plain"], 
            StyleBox["+",
              FontWeight->"Plain"], 
            StyleBox[" ",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["y",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"3", "z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " a trav\[EAcute]s de la superficie dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Gamma](u, v)\), "=", 
            RowBox[{
              RowBox[{"a", " ", "cos", " ", "u", " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], "+", " ", 
              RowBox[{"a", " ", "sen", " ", "u", " ", 
                StyleBox["j",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["+",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[\(0 \[LessEqual] u \[LessEqual] \[Pi]\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          
          StyleBox[\(\(0\)\(\[LessEqual]\)\(v\)\(\[LessEqual]\)\(\[Pi]\)\(\ \
\)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ".\nc) Calcula la integral del campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y, z) = \((x, y, z)\)\)]],
  " sobre la superficie de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`z = \@\(R\^2 - x\^2 - y\^2\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 \[LessEqual] R\^2\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(\(vectorintegsuperficie[f_]\)[\[Gamma]_, {s_, smin_, smax_}, {t_, 
          tmin_, tmax_}] := 
      Integrate[
        Simplify[Apply[f, \[Gamma][s, t]]] . 
          Simplify[Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]]], {s, 
          smin, smax}, {t, tmin, tmax}]\)], "Input"],

Cell[BoxData[{
    \(Clear[F, \[Gamma], a, b, c]\), "\[IndentingNewLine]", 
    \(\(F[x_, y_, z_] = {x, y, 3  z};\)\), "\n", 
    \(\(\[Gamma][u_, v_] = {a*Cos[u], a*Sin[u], v};\)\), "\n", 
    \(\(vectorintegsuperficie[F]\)[\[Gamma], {u, 0, \[Pi]}, {v, 
        0, \[Pi]}]\)}], "Input"],

Cell[BoxData[
    \(\(vectorintegsuperficiepolares[
          f_]\)[\[Gamma]_, {\[Theta]_, \[Theta]min_, \[Theta]max_}, {\[Rho]_, \
\[Rho]min_, \[Rho]max_}] := 
      Integrate[\((Simplify[\[Rho]*Apply[f, \[Gamma][s, t]]] . 
              Simplify[
                Cross[D[\[Gamma][s, t], s], 
                  D[\[Gamma][s, t], t]]])\) /. {s \[Rule] \[Rho]*
                Cos[\[Theta]], 
            t \[Rule] \[Rho]*
                Sin[\[Theta]]}, {\[Theta], \[Theta]min, \[Theta]max}, \
{\[Rho], \[Rho]min, \[Rho]max}]\)], "Input"],

Cell[BoxData[{
    \(Clear[F, \[Gamma]]\), "\[IndentingNewLine]", 
    \(\(F[x_, y_, z_] = {x, y, z};\)\), "\n", 
    \(\(\[Gamma][u_, v_] = {u, v, \@\(R\^2 - u\^2 - v\^2\)};\)\), "\n", 
    \(Simplify[\(vectorintegsuperficiepolares[F]\)[\[Gamma], {\[Theta], 0, 
          2  \[Pi]}, {\[Rho], 0, R}], R > 0]\)}], "Input"],

Cell[BoxData[
    \(Simplify[\(vectorintegsuperficie[F]\)[\[Gamma], {u, \(-R\), 
          R}, {v, \(-\@\(R\^2 - u\^2\)\), \@\(R\^2 - u\^2\)}], 
      R > 0]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Calcula el flujo del campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\((x\^3 - z\^2 + y\^3)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"x", " ", \(y\^3\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"y", " ", "z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " a trav\[EAcute]s de la superficie del s\[OAcute]lido acotado por el plano \
XY y la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`h(x, y) = 4 - x\^2 - y\^2\)]],
  ".\na) Directamente mediante una integral de superficie.\nb) Usando el \
teorema de la divergencia."
}], "ExerciseText"],

Cell[BoxData[
    \(\(div[func_]\)[x_, y_, z_] := 
      Module[{u, v, w}, 
        D[\(func[u, v, w]\)[\([1]\)], u] + D[\(func[u, v, w]\)[\([2]\)], v] + 
            D[\(func[u, v, w]\)[\([3]\)], w] /. {u \[Rule] x, v \[Rule] y, 
            w -> z}]\)], "Input"],

Cell[BoxData[{
    \(Clear[F, \[Gamma]]\), "\[IndentingNewLine]", 
    \(\(F[x_, y_, z_] = {x\^3 - z\^2 + y\^3, x\ y\^3, y\ z};\)\), "\n", 
    \(\(\[Gamma][u_, v_] = {u, v, 4 - u\^2 - v\^2};\)\), "\n", 
    \(\(vectorintegsuperficiepolares[F]\)[\[Gamma], {\[Theta], 0, 
        2  \[Pi]}, {\[Rho], 0, 2}]\), "\[IndentingNewLine]", 
    \(\(base[u_, v_] = {u\ Cos[v], u\ Sin[v], 
          0};\)\), "\[IndentingNewLine]", 
    \(\(vectorintegsuperficie[F]\)[
      base, {u, 0, 2}, {v, 0, 2  Pi}]\), "\[IndentingNewLine]", 
    \(Integrate[
      Simplify[\[Rho]*\(div[F]\)[x, y, 
              z] /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
            y \[Rule] \[Rho]\ Sin[\[Theta]], z \[Rule] z}, \[Rho] > 
          0], {\[Rho], 0, 2}, {\[Theta], 0, 2  Pi}, {z, 0, 
        4 - \[Rho]\^2}]\)}], "Input"],

Cell["\<\
En los siguientes ejercicios puede ser conveniente usar el teorema de Stokes \
o de la divergencia.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " la superficie formada por las cinco caras superiores del cubo ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] 1, 
      0 \[LessEqual] y \[LessEqual] 1, 0 \[LessEqual] z \[LessEqual] 1\)]],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y, z) = \((x\ y, \ 0, \ \(-z\^2\))\)\)]],
  ". Calcula el flujo saliente del campo ",
  Cell[BoxData[
      \(TraditionalForm\`rot\ F\)]],
  " a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(Clear[F, \[Gamma]]\[IndentingNewLine] (*\ 
      Se\ trata\ de\ una\ superficie\ abierta\ y\ podemos\ aplicar\ el\ \
teorema\ de\ Stokes\ que\ nos\ ahorra\ el\ trabajo\ de\ hacer\ los\ \
c\[AAcute]lculos\ para\ cada\ cara . \ 
          Solamente\ hemos\ de\ calcular\ la\ circulaci\[OAcute]n\ de\ F\ a\ \
lo\ largo\ de\ la\ curva\ frontera\ de\ dicha\ superficie\ que\ es\ el\ \
cuadrado\ formado\ por\ la\ yuxtaposici\[OAcute]n\ de\ los\ segmentos\ {t, 0, 
          0}, {1, t, 0}, {t, 1, 
        0}, {0, t, 
          0}\ variando\ t\ entre\ 0\ y\ 1\ *) \), "\[IndentingNewLine]", 
    \( (*\ Alternativamente, \ 
      puede\ usarse\ el\ teorema\ de\ la\ divergencia\ que\ implica\ que\ el\ \
flujo\ saliente\ del\ rotacional\ de\ un\ campo\ a\ trav\[EAcute]s\ de\ una\ \
superficie\ cerrada\ es\ cero . \ Por\ tanto, \ 
      el\ flujo\ que\ piden\ debe\ ser\ igual\ al\ flujo\ entrante\ del\ \
campo\ \[IndentingNewLine]rot \((F)\)\ a\ trav\[EAcute]s\ de\ la\ cara\ \
inferior\ del\ cubo\ *) \)}], "Input"],

Cell[BoxData[
    \(\(rot[F_]\)[x_, y_, z_] := 
      Module[{u, v, 
          w}, {D[\(F[u, v, w]\)[\([3]\)], v] - D[\(F[u, v, w]\)[\([2]\)], w], 
            D[\(F[u, v, w]\)[\([1]\)], w] - D[\(F[u, v, w]\)[\([3]\)], u], 
            D[\(F[u, v, w]\)[\([2]\)], u] - 
              D[\(F[u, v, w]\)[\([1]\)], v]} /. {u -> x, v -> y, 
            w -> z}]\)], "Input"],

Cell[BoxData[
    \(integlineavector[F_, \[Gamma]_, a_, b_] := 
      Integrate[
        Simplify[\((F @@ \[Gamma][t])\) . \(\[Gamma]'\)[t]], {t, a, 
          b}]\)], "Input"],

Cell[BoxData[{
    \(f[x_, y_, z_] := {x\ y, 0, \(-z^2\)}\[IndentingNewLine] (*\ 
      Stokes\ *) \), "\[IndentingNewLine]", 
    \(\(\[Gamma]1[t_] = {t, 0, 0};\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma]2[t_] = {1, t, 0};\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma]3[t_] = {t, 1, 0};\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma]4[t_] = {0, t, 0};\)\), "\[IndentingNewLine]", 
    \(integlineavector[f, \[Gamma]1, 0, 1] + 
      integlineavector[f, \[Gamma]2, 0, 
        1] - \[IndentingNewLine]integlineavector[f, \[Gamma]3, 0, 1] - 
      integlineavector[f, \[Gamma]4, 0, 1]\[IndentingNewLine] (*\ 
      Divergencia\ *) \), "\[IndentingNewLine]", 
    \(\(\[Gamma][s_, t_] = {s, t, 0};\)\), "\[IndentingNewLine]", 
    \(Cross[D[\[Gamma][s, t], s], D[\[Gamma][s, t], t]] (*\ 
      orientaci\[OAcute]n\ hacia\ adentro\ *) \), "\[IndentingNewLine]", 
    \(\(vectorintegsuperficie[rot[f]]\)[\[Gamma], {s, 0, 1}, {t, 0, 
        1}]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Se considera el s\[OAcute]lido ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " limitado por la superficie cil\[IAcute]ndrica ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 2  y\)]],
  " y los planos ",
  Cell[BoxData[
      \(TraditionalForm\`z = 0, \ y + z = 2\)]],
  ". Calcular el flujo saliente del campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm
      \`F(x, y, z) = 
        \((x\^2 + sen\ z, \ x\ y\  + \ cos\ z, \ \[ExponentialE]\^y)\)\)]],
  " a trav\[EAcute]s de la superficie frontera ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(Clear[f, \[Gamma], F]\[IndentingNewLine] (*\ 
      procede\ aplicar\ el\ teorema\ de\ la\ divergencia\ *) \), "\
\[IndentingNewLine]", 
    \(\(F[x_, y_, z_] = {x^2 + Sin[z], x*y + Cos[z], 
          Exp[y]};\)\), "\[IndentingNewLine]", 
    \(Integrate[\[Rho]*\(div[F]\)[x, y, 
            z] /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
          y \[Rule] \[Rho]\ Sin[\[Theta]], z -> z}, {\[Rho], 
        0, \@2}, {\[Theta], 0, 2  Pi}, {z, 0, 
        2 - \[Rho]\ Sin[\[Theta]]}]\), "\[IndentingNewLine]", 
    \(Integrate[\(div[F]\)[x, y, z], {x, \(-1\), 1}, {y, 1 - \@\(1 - x\^2\), 
        1 + \@\(1 - x\^2\)}, {z, 0, 2 - y}]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Calcular la integral de l\[IAcute]nea ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_\[Gamma]\(-y\) \[DifferentialD]x + 
        \(x\^3\) \[DifferentialD]y - \(z\^3\) \[DifferentialD]z\)]],
  " donde \[Gamma] es la curva intersecci\[OAcute]n del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 1\)]],
  " con el plano ",
  Cell[BoxData[
      \(TraditionalForm\`x + y + z = 1\)]],
  " y la orientaci\[OAcute]n de \[Gamma] es en sentido antihorario."
}], "ExerciseText"],

Cell[BoxData[{
    \(Clear[F]\), "\[IndentingNewLine]", 
    \(F[x_, y_, z_] := {\(-y\), x^3, \(-z^3\)}\), "\[IndentingNewLine]", 
    \(\(\[Gamma][t_] = {Cos[t], Sin[t], 
          1 - Cos[t] - Sin[t]};\)\), "\[IndentingNewLine]", 
    \(integlineavector[F, \[Gamma], 0, 2  Pi]\)}], "Input"],

Cell[BoxData[{
    \(\(\[Gamma][s_, t_] = {s*Cos[t], s*Sin[t], 
          1 - s*Cos[t] - s*Sin[t]};\)\[IndentingNewLine] (*\ 
      aplicando\ el\ teorema\ de\ Stokes\ *) \), "\[IndentingNewLine]", 
    \(\(vectorintegsuperficie[rot[F]]\)[\[Gamma], {s, 0, 1}, {t, 0, 
        2  Pi}]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Sea \[Gamma] la curva intersecci\[OAcute]n de las superficies de \
ecuaciones ",
  Cell[BoxData[
      \(TraditionalForm\`z = 50 - x\^2 - \((y - 6)\)\^2\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`z = \ x\^2 + y\^2\)]],
  ". Justifica que \[Gamma] se encuentra situada en un plano y expresa \
\[Gamma] por medio de ecuaciones param\[EAcute]tricas que la describan en \
sentido antihorario cuando se la v\[EAcute] desde arriba. Calcula la \
circulaci\[OAcute]n del campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y, z) = \((2  x\ z - z\^2, y\^2 - 2\ x\ y, \ 
          y\ z)\)\)]],
  " a lo largo de \[Gamma] de tres formas distintas:\na) Aplicando \
directamente la definici\[OAcute]n.\nb) Aplicando el teorema de Stokes a la \
parte del plano acotada por \[Gamma].\nc) Aplicando el teorema de Stokes a la \
parte de la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`z = \(\(x\^2\)\(+\)\(y\^2\)\(\ \)\)\)]],
  "acotada por \[Gamma]."
}], "ExerciseText"],

Cell[BoxData[{
    \(Simplify[
      50 - x\^2 - \((y - 6)\)\^2 \[Equal] 
        x\^2 + y\^2]\), "\[IndentingNewLine]", 
    \(Expand[
        50 - x\^2 - \((y - 6)\)\^2] /. {x\^2 + y\^2 \[Rule] 
          7 + 6  y, \(-x\^2\) - y\^2 \[Rule] \(-7\) - 
            6  y}\[IndentingNewLine] (*\ 
      las\ dos\ superficies\ se\ cortan\ en\ una\ curva\ contenida\ en\ \
\[IndentingNewLine]el\ plano\ z = 7 + 6  y\ *) \), "\[IndentingNewLine]", 
    \( (*\ la\ curva\ x\^2 + \ 
          y\^2\  = \ \(7\  + \ 
            6  y\ es\ la\ circunferencia\ x\^2 + \((y - 3)\)\^2 = 
          16\)\ *) \)}], "Input"],

Cell[BoxData[{
    \(\(sup1[x_, y_] := 
        If[x\^2 + \((y - 3)\)\^2 < 16, x\^2 + y\^2, 
          0];\)\), "\[IndentingNewLine]", 
    \(\(graf1 = 
        Plot3D[sup1[x, y], {x, \(-4\), 4}, {y, \(-1\), 7}, 
          PlotPoints \[Rule] 80, Boxed \[Rule] False, Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma][t_] = {4\ Cos[t], 3 + 4  Sin[t], 
          25 + 24\ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(\(graf2 = 
        ParametricPlot3D[{4\ Cos[t], 3 + 4  Sin[t], 
            25 + 24\ Sin[t], {Hue[0], Thickness[ .007]}}, {t, 0, 2  Pi}, 
          Boxed \[Rule] False, Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[graf1, graf2, DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {274.625, 222.688}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(sup2[x_, y_] := 
        If[x\^2 + \((y - 3)\)\^2 < 16, 50 - x\^2 - \((y - 6)\)\^2, 
          0];\)\), "\[IndentingNewLine]", 
    \(\(graf3 = 
        Plot3D[sup2[x, y], {x, \(-4\), 4}, {y, \(-1\), 7}, 
          PlotPoints \[Rule] 80, Boxed \[Rule] False, Axes \[Rule] False, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[graf3, graf2, DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {274.625, 222.688}];\)\)}], "Input"],

Cell[BoxData[{
    \(Clear[F]\), "\[IndentingNewLine]", 
    \(\(F[x_, y_, z_] = {2*x*z - z^2, y^2 - 2*x*y, y*z}\ ;\)\), "\n", 
    \(\(\[Gamma][t_] = {4\ Cos[t], 3 + 4  Sin[t], 
          25 + 24\ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(integlineavector[F, \[Gamma], 0, 2  Pi]\[IndentingNewLine] (*\ 
      parte\ del\ plano\ z = 
        7 + 6  y\ acotada\ por\ \[Gamma]\ *) \), "\[IndentingNewLine]", 
    \(\(super[s_, t_] = {4*s*Cos[t], 4*s*Sin[t] + 3, 
          25 + 24\ s\ *Sin[t]};\)\), "\n", 
    \(\(vectorintegsuperficie[rot[F]]\)[
      super, {s, 0, 1}, {t, 0, 2\ Pi}]\[IndentingNewLine] (*\ 
      parte\ de\ la\ superficie\ z = 
        x\^2 + y\^2\ acotada\ por\ \[Gamma]\ *) \), "\[IndentingNewLine]", 
    \(\(super2[s_, t_] = {4*s*Cos[t], 4*s*Sin[t] + 3, 
          9 + 16\ s\^2 + 24\ s\ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(\(vectorintegsuperficie[rot[F]]\)[
      super, {s, 0, 1}, {t, 0, 2\ Pi}]\)}], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Integrales de superficie. Teoremas de la divergencia y de Stokes"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Integrales de superficie. Teoremas de la divergencia y de Stokes"], 
        "Header"]}},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FacingPages"->True},
ShowCellLabel->False,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 89, 2, 174, "Title"],
Cell[1846, 55, 189, 7, 130, "Author"],

Cell[CellGroupData[{
Cell[2060, 66, 33, 0, 93, "Section"],
Cell[2096, 68, 143, 3, 124, "Input"],
Cell[2242, 73, 51, 1, 72, "Input"],
Cell[2296, 76, 52, 1, 72, "Input"],
Cell[2351, 79, 660, 12, 236, "Input"],
Cell[3014, 93, 938, 16, 332, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3989, 114, 43, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[4057, 118, 31, 0, 68, "Exercise"],
Cell[4091, 120, 2162, 59, 195, "ExerciseText"],
Cell[6256, 181, 1131, 23, 315, "Input"],
Cell[7390, 206, 1165, 24, 314, "Input"],
Cell[8558, 232, 1154, 24, 332, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9749, 261, 31, 0, 68, "Exercise"],
Cell[9783, 263, 670, 10, 153, "ExerciseText"],
Cell[10456, 275, 531, 9, 176, "Input"],
Cell[10990, 286, 253, 4, 67, "ExerciseText"],
Cell[11246, 292, 1781, 54, 237, "ExerciseText"],
Cell[13030, 348, 579, 12, 119, "ExerciseText"],
Cell[13612, 362, 320, 7, 150, "Input"],
Cell[13935, 371, 190, 3, 135, "Input"],
Cell[14128, 376, 284, 6, 165, "Input"],
Cell[14415, 384, 229, 4, 148, "Input"],
Cell[14647, 390, 301, 6, 147, "Input"],
Cell[14951, 398, 521, 10, 117, "Input"],
Cell[15475, 410, 263, 5, 147, "Input"],
Cell[15741, 417, 132, 2, 63, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15910, 424, 31, 0, 37, "Exercise"],
Cell[15944, 426, 518, 12, 63, "ExerciseText"],
Cell[16465, 440, 244, 4, 43, "Text"],
Cell[16712, 446, 1249, 32, 123, "ExerciseText"],
Cell[17964, 480, 330, 6, 87, "Input"],
Cell[18297, 488, 382, 6, 87, "Input"],
Cell[18682, 496, 1015, 20, 327, "Input"],
Cell[19700, 518, 142, 3, 57, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19879, 526, 31, 0, 37, "Exercise"],
Cell[19913, 528, 3376, 86, 325, "ExerciseText"],
Cell[23292, 616, 307, 6, 150, "Input"],
Cell[23602, 624, 287, 5, 150, "Input"],
Cell[23892, 631, 538, 11, 176, "Input"],
Cell[24433, 644, 321, 5, 192, "Input"],
Cell[24757, 651, 170, 3, 63, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24964, 659, 31, 0, 37, "Exercise"],
Cell[24998, 661, 836, 21, 88, "ExerciseText"],
Cell[25837, 684, 264, 5, 87, "Input"],
Cell[26104, 691, 802, 15, 273, "Input"],
Cell[26909, 708, 123, 3, 46, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27069, 716, 31, 0, 37, "Exercise"],
Cell[27103, 718, 591, 18, 37, "ExerciseText"],
Cell[27697, 738, 1034, 17, 297, "Input"],
Cell[28734, 757, 368, 7, 147, "Input"],
Cell[29105, 766, 176, 4, 57, "Input"],
Cell[29284, 772, 955, 16, 387, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30276, 793, 31, 0, 37, "Exercise"],
Cell[30310, 795, 678, 22, 63, "ExerciseText"],
Cell[30991, 819, 661, 12, 187, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31689, 836, 31, 0, 37, "Exercise"],
Cell[31723, 838, 524, 13, 42, "ExerciseText"],
Cell[32250, 853, 292, 5, 147, "Input"],
Cell[32545, 860, 297, 5, 117, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32879, 870, 31, 0, 37, "Exercise"],
Cell[32913, 872, 1010, 22, 139, "ExerciseText"],
Cell[33926, 896, 607, 13, 168, "Input"],
Cell[34536, 911, 872, 16, 196, "Input"],
Cell[35411, 929, 509, 9, 106, "Input"],
Cell[35923, 940, 943, 17, 316, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

